<?php
//remember to increment db version when new social media are added.
return array(
    0 => array(
        'id'      => 1,
        'class'      => 'twitter',
        'alt-name'  => 'x',
        'share'        => 'https://twitter.com/share?url={url}&text={title}',
        'icon'        => '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
        <g transform="matrix(1, 0, 0, 1, 3.980892, 4.77707)"><path fill="#e7e9ea" d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"></path></g>
        </svg>',
    ),
    1 => array(
        'id'      => 2,
        'class'      => 'facebook',
        'share'        => 'https://www.facebook.com/sharer.php?u={url}',
        'icon'        =>  '<svg width="430.11px" height="430.11px" enable-background="new 0 0 430.113 430.114" version="1.1" viewBox="0 0 430.113 430.114" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">  <path d="m158.08 83.3v59.218h-43.385v72.412h43.385v215.18h89.122v-215.18h59.805s5.601-34.721 8.316-72.685h-67.784s0-42.127 0-49.511c0-7.4 9.717-17.354 19.321-17.354h48.557v-75.385h-66.021c-93.519-5e-3 -91.316 72.479-91.316 83.299z"/></svg>',
    ),
    2 => array(
        'id'      => 3,
        'class'      => 'instagram',
        'share'        => '',
        'icon'        =>  '<svg enable-background="new 0 0 512 512" version="1.1" viewBox="0 0 512 512" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="M352,0H160C71.648,0,0,71.648,0,160v192c0,88.352,71.648,160,160,160h192c88.352,0,160-71.648,160-160V160    C512,71.648,440.352,0,352,0z M464,352c0,61.76-50.24,112-112,112H160c-61.76,0-112-50.24-112-112V160C48,98.24,98.24,48,160,48    h192c61.76,0,112,50.24,112,112V352z"/>
									<path d="m256 128c-70.688 0-128 57.312-128 128s57.312 128 128 128 128-57.312 128-128-57.312-128-128-128zm0 208c-44.096 0-80-35.904-80-80 0-44.128 35.904-80 80-80s80 35.872 80 80c0 44.096-35.904 80-80 80z"/>
									<circle cx="393.6" cy="118.4" r="17.056"/>
								</svg>',
    ),
    3 => array(
        'id'      => 4,
        'class'      => 'youtube',
        'share'        => '',
        'icon'        =>  '<svg enable-background="new 0 0 90 90" version="1.1" viewBox="0 0 90 90" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="M90,26.958C90,19.525,83.979,13.5,76.55,13.5h-63.1C6.021,13.5,0,19.525,0,26.958v36.084   C0,70.475,6.021,76.5,13.45,76.5h63.1C83.979,76.5,90,70.475,90,63.042V26.958z M36,60.225V26.33l25.702,16.947L36,60.225z"/>
								</svg>',
    ),
    4 => array(
        'id'      => 5,
        'class'      => 'pinterest',
        'share'        => 'https://pinterest.com/pin/create/bookmarklet/?media={img}&url={url}&is_video=false&description={title}',
        'icon'        =>  '<svg enable-background="new 0 0 310.05 310.05" version="1.1" viewBox="0 0 310.05 310.05" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="m245.26 31.772c-21.342-20.488-50.877-31.772-83.164-31.772-49.32 0-79.654 20.217-96.416 37.176-20.658 20.9-32.504 48.651-32.504 76.139 0 34.513 14.436 61.003 38.611 70.858 1.623 0.665 3.256 1 4.857 1 5.1 0 9.141-3.337 10.541-8.69 0.816-3.071 2.707-10.647 3.529-13.936 1.76-6.495 0.338-9.619-3.5-14.142-6.992-8.273-10.248-18.056-10.248-30.788 0-37.818 28.16-78.011 80.352-78.011 41.412 0 67.137 23.537 67.137 61.425 0 23.909-5.15 46.051-14.504 62.35-6.5 11.325-17.93 24.825-35.477 24.825-7.588 0-14.404-3.117-18.705-8.551-4.063-5.137-5.402-11.773-3.768-18.689 1.846-7.814 4.363-15.965 6.799-23.845 4.443-14.392 8.643-27.985 8.643-38.83 0-18.55-11.404-31.014-28.375-31.014-21.568 0-38.465 21.906-38.465 49.871 0 13.715 3.645 23.973 5.295 27.912-2.717 11.512-18.865 79.953-21.928 92.859-1.771 7.534-12.44 67.039 5.219 71.784 19.841 5.331 37.576-52.623 39.381-59.172 1.463-5.326 6.582-25.465 9.719-37.845 9.578 9.226 25 15.463 40.006 15.463 28.289 0 53.73-12.73 71.637-35.843 17.367-22.418 26.932-53.664 26.932-87.978 0-26.826-11.52-53.272-31.604-72.556z"/>
								</svg>',
    ),
    5 => array(
        'id'      => 6,
        'class'      => 'linkedin',
        'share'        => 'https://www.linkedin.com/shareArticle?url={url}&title={title}',
        'icon'        =>  '<svg width="430.12px" height="430.12px" enable-background="new 0 0 430.117 430.117" version="1.1" viewBox="0 0 430.117 430.117" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="m430.12 261.54v159.02h-92.188v-148.37c0-37.271-13.334-62.707-46.703-62.707-25.473 0-40.632 17.142-47.301 33.724-2.432 5.928-3.058 14.179-3.058 22.477v154.87h-92.219s1.242-251.28 0-277.32h92.21v39.309c-0.187 0.294-0.43 0.611-0.606 0.896h0.606v-0.896c12.251-18.869 34.13-45.824 83.102-45.824 60.673-1e-3 106.16 39.636 106.16 124.82zm-377.93-251.98c-31.548 0-52.183 20.693-52.183 47.905 0 26.619 20.038 47.94 50.959 47.94h0.616c32.159 0 52.159-21.317 52.159-47.94-0.606-27.212-20-47.905-51.551-47.905zm-46.706 411h92.184v-277.32h-92.184v277.32z"/>
								</svg>',
    ),
    6 => array(
        'id'      => 7,
        'class'      => 'flickr',
        'share'        => '',
        'icon'        =>  '<svg enable-background="new 0 0 90 90" version="1.1" viewBox="0 0 90 90" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="M90,45.004C90,56.047,80.973,65,69.83,65c-11.139,0-20.169-8.953-20.169-19.996   C49.661,33.955,58.691,25,69.83,25C80.973,25,90,33.955,90,45.004z M20.169,25C9.03,25,0,33.955,0,45.004   C0,56.047,9.03,65,20.169,65s20.169-8.953,20.169-19.996C40.338,33.955,31.308,25,20.169,25z"/>
								</svg>',
    ),
    7 => array(
        'id'      => 8,
        'class'      => 'github',
        'share'        => '',
        'icon'        =>  '<svg enable-background="new 0 0 90 90" version="1.1" viewBox="0 0 90 90" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="m65.709 10.5c1.17 2.657 1.928 7.07 0.797 10.301 4.625 3.949 6.215 13.549 3.982 21.394 6.592 0.503 14.444-0.242 19.512 1.781-4.738-0.609-11.209-1.804-17.32-1.388-1.158 0.079-2.873-0.044-2.789 1.585 7.074 0.555 14.104 1.16 19.912 2.973-5.761-0.941-12.754-2.375-19.912-2.574-2.957 5.835-8.908 8.703-17.123 9.307 0.883 1.922 2.574 2.653 2.987 5.744 0.616 4.618-0.964 11.381 0.595 14.459 0.748 1.475 1.967 1.514 2.789 2.775-2.012 2.381-7-0.268-7.568-2.775-0.973-4.295 1.482-10.953-1.192-13.865 0.188 4.685-1.108 11.264 0.199 15.449 0.515 1.646 2.002 2.281 1.593 3.766-9.352 0.949-5.443-12.104-6.972-19.81-1.411 0.101-0.791 2.113-0.796 2.972-0.04 7.524 1.54 17.844-6.57 16.838-0.237-1.582 1.088-2.119 1.593-3.563 1.479-4.233-0.277-10.542 0.401-15.651-3.095 2.334 0.325 10.48-1.593 14.657-1.105 2.404-4.666 3.45-7.367 2.377 0.352-1.79 2.2-1.501 2.984-3.169 1.096-2.324 8e-3 -5.674 0.399-9.111-5.729 1.144-10.173-0.166-12.348-3.764-0.973-1.615-1.214-3.52-2.39-4.951-1.17-1.432-3.04-1.625-3.582-3.563 7.095-1.708 7.367 7.302 13.739 7.524 1.954 0.071 2.97-0.563 4.778-0.988 0.506-2.272 1.589-3.967 3.186-5.153-7.929-1.085-14.477-3.554-17.522-9.504-7.208 0.354-13.804 1.317-19.913 2.771 5.545-2.014 12.384-2.736 19.715-2.973-0.432-2.596-4.219-1.882-6.57-1.782-4.37 0.192-9.87 0.735-13.343 1.387 5.034-1.795 12.098-1.571 18.918-1.585-2.086-6.54-1.363-16.929 3.186-20.798-1.289-3.249-0.889-8.563 0.796-11.093 5.079 0.228 8.159 2.443 11.35 4.557 3.957-1.125 8.118-1.685 13.54-1.387 2.28 0.126 4.651 1.151 6.369 0.989 1.685-0.158 3.542-2.049 5.178-2.771 2.131-0.941 3.934-1.3 6.372-1.388z"/>
								</svg>',
    ),
    8 => array(
        'id'      => 9,
        'class'      => 'snapchat',
        'share'        => '',
        'icon'        =>  '<svg enable-background="new 0 0 468.339 468.339" version="1.1" viewBox="0 0 468.339 468.339" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="m233.96 33.724c62.857 0.021 115.22 52.351 115.29 115.36 0.018 14.758 0.473 28.348 1.306 40.867 0.514 7.724 6.938 13.448 14.305 13.448 1.085 0 2.19-0.124 3.3-0.384l19.691-4.616c0.838-0.197 1.679-0.291 2.51-0.291 5.001 0 9.606 3.417 10.729 8.478 1.587 7.152-2.42 14.378-9.35 16.808l-29.89 12.066c-7.546 3.046-11.599 11.259-9.474 19.115 23.98 88.654 90.959 79.434 90.959 90.984 0 14.504-50.485 16.552-55.046 21.114s-0.198 26.701-10.389 30.987c-1.921 0.808-4.65 1.089-7.979 1.089-7.676 0-18.532-1.498-29.974-1.498-9.925 0-20.291 1.127-29.404 5.337-24.176 11.168-47.484 32.028-76.378 32.028s-52.202-20.86-76.378-32.028c-9.115-4.211-19.478-5.337-29.404-5.337-11.441 0-22.299 1.498-29.974 1.498-3.327 0-6.059-0.282-7.979-1.089-10.191-4.286-5.828-26.425-10.389-30.987s-55.046-6.611-55.046-21.115c0-11.551 66.979-2.331 90.959-90.984 2.125-7.855-1.928-16.068-9.475-19.115l-29.89-12.066c-6.931-2.43-10.938-9.656-9.35-16.808 1.123-5.062 5.728-8.479 10.729-8.478 0.83 0 1.672 0.094 2.51 0.291l19.691 4.616c1.11 0.26 2.215 0.384 3.3 0.384 7.366 0 13.791-5.725 14.305-13.448 0.833-12.519 1.289-26.109 1.307-40.867 0.076-63.008 52.018-115.34 114.88-115.36m8e-3 -25h-0.018c-18.762 6e-3 -37.039 3.776-54.321 11.206-16.589 7.131-31.519 17.299-44.375 30.222-12.839 12.906-22.943 27.889-30.031 44.533-7.37 17.307-11.118 35.599-11.141 54.368-0.011 9.215-0.202 18.158-0.57 26.722l-7.326-1.718c-2.688-0.63-5.452-0.95-8.213-0.951-7.973-1e-3 -15.838 2.694-22.146 7.588-6.581 5.106-11.196 12.377-12.993 20.474-4.277 19.273 6.365 38.73 24.807 45.572l21.937 8.855c-14.526 44.586-41.311 53.13-59.348 58.885-4.786 1.527-8.92 2.846-12.856 4.799-15.683 7.784-17.376 20.971-17.376 26.279 0 10.167 4.812 19.445 13.551 26.124 4.351 3.326 9.741 6.07 16.477 8.389 9.181 3.161 19.824 5.167 28.474 6.775 0.418 3.205 1.031 6.648 2.064 10.118 4.289 14.411 13.34 20.864 20.178 23.739 6.488 2.729 13.192 3.044 17.67 3.044 4.38 0 9.01-0.343 13.912-0.706 5.259-0.39 10.697-0.792 16.062-0.792 8.314 0 14.503 0.992 18.92 3.032 6.065 2.802 12.497 6.58 19.307 10.579 18.958 11.134 40.445 23.754 67.555 23.754s48.596-12.62 67.554-23.754c6.81-4 13.242-7.777 19.308-10.579 4.417-2.041 10.606-3.032 18.92-3.032 5.365 0 10.803 0.403 16.061 0.792 4.902 0.363 9.532 0.706 13.912 0.706 4.478 0 11.181-0.315 17.67-3.044 6.838-2.875 15.889-9.328 20.178-23.739 1.033-3.47 1.647-6.913 2.064-10.118 8.65-1.609 19.294-3.614 28.474-6.775 6.737-2.319 12.126-5.063 16.477-8.389 8.738-6.679 13.551-15.957 13.551-26.124 0-5.308-1.693-18.495-17.378-26.278-3.936-1.953-8.07-3.272-12.856-4.799-18.037-5.754-44.822-14.299-59.348-58.885l21.936-8.855c18.442-6.842 29.085-26.3 24.808-45.573-1.797-8.097-6.412-15.368-12.993-20.474-6.308-4.893-14.171-7.588-22.142-7.588-2.761 0-5.525 0.32-8.215 0.95l-7.327 1.718c-0.368-8.563-0.559-17.506-0.57-26.722-0.023-18.784-3.801-37.094-11.23-54.424-7.131-16.636-17.29-31.615-30.194-44.522-12.903-12.906-27.875-23.063-44.498-30.188-17.315-7.421-35.605-11.187-54.362-11.194z" fill="#050505"/>
								</svg>',
    ),
    9 => array(
        'id'      => 10,
        'class'      => 'tumblr',
        'share'        => 'https://www.tumblr.com/share/link?url={url}&name={title}&description={description}',
        'icon'        =>  '<svg width="430.12px" height="430.12px" enable-background="new 0 0 430.118 430.118" version="1.1" viewBox="0 0 430.118 430.118" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="m252.8 351.54c-7.229-4.247-13.866-11.547-16.513-18.589-2.679-7.09-2.338-21.455-2.338-46.419v-110.29h100.3v-76.766h-100.3v-99.477h-61.713c-2.753 22.155-7.824 40.459-15.18 54.815-7.369 14.377-17.088 26.658-29.276 36.924-12.127 10.246-31.895 18.143-48.927 23.589v60.915h58.922v150.84c0 19.694 2.088 34.718 6.24 45.061 4.172 10.333 11.623 20.124 22.386 29.337 10.762 9.115 23.758 16.228 39.003 21.226 15.227 4.942 26.936 7.416 46.767 7.416 17.445 0 33.687-1.759 48.747-5.198 15.042-3.529 31.834-9.605 50.344-18.221v-67.859c-21.721 14.169-43.567 21.221-65.535 21.221-12.365 3e-3 -23.294-2.839-32.932-8.519z"/>
								</svg>',
    ),
    10 => array(
        'id'      => 11,
        'class'      => 'vimeo',
        'share'        => '',
        'icon'        =>  '<svg width="430.12px" height="430.12px" enable-background="new 0 0 430.118 430.118" version="1.1" viewBox="0 0 430.118 430.118" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="m367.24 28.754c-59.795-1.951-100.26 31.591-121.45 100.66 10.912-4.494 21.516-6.762 31.858-6.762 21.804 0 31.455 12.237 28.879 36.776-1.278 14.86-10.911 36.482-28.879 64.858-18.039 28.423-31.513 42.61-40.464 42.61-11.621 0-22.199-21.958-31.857-65.82-3.239-12.918-9.031-45.812-17.324-98.765-7.775-49.046-28.32-71.962-61.727-68.741-14.132 1.299-35.302 14.241-63.556 38.734-20.613 18.724-41.498 37.453-62.726 56.163l20.225 26.112c19.303-13.562 30.595-20.311 33.731-20.311 14.802 0 28.625 23.219 41.488 69.651 11.53 42.644 23.158 85.23 34.744 127.81 17.256 46.466 38.529 69.708 63.552 69.708 40.473 0 90.028-38.065 148.47-114.22 56.537-72.909 85.725-130.35 87.694-172.34 2.595-56.115-18.29-84.851-62.66-86.125z"/>
								</svg>',
    ),
    11 => array(
        'id'      => 12,
        'class'      => 'foursquare',
        'share'        => '',
        'icon'        =>  '<svg enable-background="new 0 0 300 300" version="1.1" viewBox="0 0 300 300" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="m253.43 8.709c-5.318-7.936-15.699-8.816-24.402-8.699-52.447 0.236-104.91 0.1-157.38 0.059-3.011 0.093-6.017 0.251-8.984 0.831-9.628 1.6-17.55 9.688-19.241 19.238-1.545 9.416-0.655 19.025-0.773 28.52-0.02 77.041 0.059 154.08-0.059 231.12 0.217 4.752 0.389 9.938 3.336 13.943 4.645 6.346 14.056 7.93 20.924 4.516 4.139-2.254 7.203-5.924 10.287-9.377 22.539-26.607 45.973-52.461 68.467-79.113 2.484-2.818 5.396-5.904 9.516-5.672 16.225-0.832 32.49 0.545 48.736-0.291 5.516-0.289 11.262-1.865 15.262-5.879 5.451-5.357 7.144-13.141 8.871-20.305 9.219-44.688 17.568-89.563 26.822-134.25 2.175-11.277 5.398-24.301-1.377-34.646zm-40.471 72.382c-1.339 4.432-7.105 4.133-10.986 4.447-19.508 0.389-39.02-0.469-58.508 0.094-5.959-0.232-12.404 3.512-12.773 9.977-1.264 8.059-0.752 20.496 9.358 22.268 19.099 2.135 38.454-0.703 57.573 1.146 6.366 0.191 6.484 7.705 5.49 12.344-2.189 11.232-3.857 22.646-7.139 33.643-0.836 3.641-4.295 5.551-7.842 5.58-16.113 1.348-32.324-0.557-48.432 0.59-6.604 0.094-10.539 6.018-14.445 10.465-16.246 19.971-32.59 39.848-49.362 59.379-0.659-62.832 0.06-125.69-0.368-188.54 0.137-4.699-0.1-9.609 1.627-14.076 2.471-5.201 8.971-5.068 13.865-5.34 38.258 0.041 76.535 0.139 114.8-0.039 6.346 0.195 13.022-0.859 14.676 4.793 2.19 7.481-4.557 33.423-7.531 43.27z" clip-rule="evenodd" fill-rule="evenodd"/>
								</svg>',
    ),
    12 => array(
        'id'      => 13,
        'class'      => 'behance',
        'share'        => '',
        'icon'        =>  '<svg width="430.12px" height="430.12px" enable-background="new 0 0 430.123 430.123" version="1.1" viewBox="0 0 430.123 430.123" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="m388.43 119.12h-107.77v-26.77h107.78v26.77h-9e-3zm-179.52 109.78c6.954 10.771 10.429 23.849 10.429 39.203 0 15.878-3.918 30.122-11.889 42.704-5.071 8.326-11.367 15.359-18.932 21.021-8.52 6.548-18.607 11.038-30.203 13.437-11.633 2.403-24.224 3.617-37.787 3.617h-120.53v-267.63h129.25c32.579 0.53 55.676 9.969 69.315 28.506 8.184 11.369 12.239 25.011 12.239 40.868 0 16.362-4.104 29.454-12.368 39.401-4.597 5.577-11.388 10.65-20.378 15.229 13.617 4.985 23.949 12.835 30.854 23.644zm-147.19-42.135h56.632c11.638 0 21.046-2.212 28.292-6.634 7.241-4.415 10.854-12.263 10.854-23.531 0-12.449-4.784-20.712-14.375-24.689-8.244-2.763-18.792-4.186-31.591-4.186h-49.812v59.04zm101.23 77.515c0-13.902-5.682-23.513-17.023-28.67-6.342-2.931-15.29-4.429-26.763-4.536h-57.445v71.322h56.556c11.619 0 20.612-1.521 27.102-4.694 11.704-5.834 17.573-16.937 17.573-33.422zm265.47-43.539c1.302 8.756 1.891 21.46 1.652 38.065h-139.58c0.77 19.266 7.421 32.739 20.035 40.449 7.607 4.835 16.83 7.196 27.63 7.196 11.388 0 20.67-2.879 27.815-8.797 3.893-3.137 7.327-7.565 10.296-13.152h51.16c-1.34 11.379-7.5 22.92-18.57 34.648-17.151 18.641-41.205 27.988-72.097 27.988-25.52 0-48.011-7.883-67.533-23.592-19.457-15.764-29.229-41.33-29.229-76.795 0-33.257 8.773-58.712 26.378-76.43 17.67-17.751 40.474-26.586 68.583-26.586 16.661 0 31.68 2.978 45.079 8.965 13.357 5.993 24.396 15.425 33.09 28.388 7.868 11.416 12.928 24.616 15.289 39.653zm-50.357 4.994c-0.938-13.322-5.386-23.405-13.395-30.296-7.943-6.91-17.866-10.379-29.706-10.379-12.886 0-22.836 3.708-29.906 10.996-7.118 7.273-11.547 17.161-13.362 29.68h86.369v-1e-3z"/>
								</svg>',
    ),
    13 => array(
        'id'      => 14,
        'class'      => 'medium',
        'share'        => '',
        'icon'        =>  '<svg enable-background="new 0 0 483.86 483.86" version="1.1" viewBox="0 0 483.86 483.86" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="m483.86 112.34h-26.699c-6.952 0-25.143 7.552-25.143 13.981v233.47c0 6.445 18.191 11.729 25.143 11.729h26.699v51.835h-172.81v-51.835h34.57v-241.91h-6.016l-83.186 293.74h-64.406l-82.11-293.74h-6.219v241.91h34.555v51.835h-138.24v-51.835h19.173c7.527 0 15.383-5.283 15.383-11.729v-233.47c0-6.43-7.855-13.981-15.383-13.981h-19.173v-51.841h179.16l58.496 207.34h1.574l59.073-207.34h185.56v51.841z"/>
								</svg>',
    ),
    14 => array(
        'id'      => 15,
        'class'      => 'reddit',
        'share'        => 'https://reddit.com/submit?url={url}&title={title}',
        'icon'        =>  '<svg width="430.12px" height="430.12px" enable-background="new 0 0 430.117 430.117" version="1.1" viewBox="0 0 430.117 430.117" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="m307.52 231.06c1.11 2.838 1.614 5.769 1.614 8.681 0 5.862-2.025 11.556-5.423 16.204-3.36 4.593-8.121 8.158-13.722 9.727h0.01c-0.047 0.019-0.094 0.019-0.117 0.037-0.023 0-0.061 0.019-0.079 0.019-2.623 0.896-5.312 1.316-7.98 1.316-6.254 0-12.396-2.254-17.306-6.096-4.872-3.826-8.56-9.324-9.717-15.845h-0.01c0-0.019 0-0.042-9e-3 -0.069 0-0.019 0-0.038-0.019-0.065h0.019c-0.364-1.681-0.551-3.36-0.551-5.021 0-5.647 1.923-11.07 5.097-15.551 3.164-4.453 7.626-7.99 12.848-9.811 0.019 0 0.038-0.01 0.038-0.01 0.027 0 0.027-0.027 0.051-0.027 2.954-1.092 6.072-1.639 9.157-1.639 5.619 0 11.154 1.704 15.821 4.821 4.611 3.066 8.354 7.561 10.23 13.143 0.019 0.037 0.019 0.07 0.037 0.103 0 0.037 0.019 0.057 0.037 0.084h-0.026zm-17.194 69.287c-2.202-1.428-4.751-2.291-7.448-2.291-2.175 0-4.434 0.621-6.445 1.955-19.004 11.342-41.355 17.558-63.547 17.558-16.65 0-33.199-3.514-48.192-10.879l-0.077-0.037-0.075-0.028c-2.261-0.924-4.837-2.889-7.647-4.76-1.428-0.925-2.919-1.844-4.574-2.521-1.633-0.695-3.447-1.181-5.386-1.181-1.605 0-3.292 0.359-4.957 1.115-0.086 0.033-0.168 0.065-0.252 0.098h9e-3c-2.616 0.999-4.66 2.829-5.974 4.994-1.372 2.23-2.046 4.826-2.046 7.411 0 2.334 0.551 4.667 1.691 6.786 1.085 2.007 2.754 3.762 4.938 4.938 21.429 14.454 46.662 21.002 71.992 20.979 22.838 0 45.814-5.287 66.27-14.911l0.107-0.065 0.103-0.056c2.697-1.597 6.282-3.029 9.661-5.115 1.671-1.064 3.304-2.296 4.704-3.897 1.4-1.591 2.525-3.551 3.16-5.875v-0.01c0.266-1.026 0.392-2.025 0.392-3.024 0-1.899-0.467-3.701-1.241-5.32-1.134-2.438-2.991-4.435-5.166-5.864zm-150.45-34.76c0.037 0 0.086 0.014 0.128 0.037 2.735 0.999 5.554 1.493 8.345 1.493 6.963 0 13.73-2.852 18.853-7.5 5.115-4.662 8.618-11.257 8.618-18.775 0-0.196 0-0.392-9e-3 -0.625 0.019-0.336 0.028-0.705 0.028-1.083 0-7.458-3.456-14.08-8.522-18.762-5.085-4.686-11.836-7.551-18.825-7.551-1.867 0-3.769 0.219-5.628 0.653-0.028 0-0.049 9e-3 -0.077 9e-3h-0.028c-9.252 1.937-17.373 8.803-20.37 18.248v0.01c0 0.019-9e-3 0.037-9e-3 0.037-0.861 2.586-1.262 5.255-1.262 7.896 0 5.787 1.913 11.426 5.211 16.064 3.269 4.56 7.894 8.145 13.448 9.819 0.04 2e-3 0.059 0.012 0.099 0.03zm290.16-67.495v0.038c0.066 0.94 0.084 1.878 0.084 2.81 0 10.447-3.351 20.493-8.941 29.016-5.218 7.976-12.414 14.649-20.703 19.177 0.532 4.158 0.84 8.349 0.84 12.526-0.01 22.495-7.766 44.607-21.272 62.329v9e-3h-0.028c-24.969 33.216-63.313 52.804-102.03 62.684h-0.01l-0.027 0.023c-20.647 5.013-41.938 7.574-63.223 7.574-31.729 0-63.433-5.722-93.018-17.585l-9e-3 -0.028h-0.028c-30.672-12.643-59.897-32.739-77.819-62.184-9.642-15.71-14.935-34.141-14.935-52.659 0-4.19 0.283-8.387 0.843-12.536-8.072-4.545-15.063-10.99-20.255-18.687-5.542-8.266-9.056-17.95-9.5-28.187v-0.159c9e-3 -14.337 6.237-27.918 15.915-37.932 9.677-10.011 22.896-16.554 37.075-16.554h0.588c1.487-0.101 2.987-0.159 4.488-0.159 7.122 0 14.26 1.153 21.039 3.752l0.037 0.028 0.038 0.012c5.787 2.437 11.537 5.377 16.662 9.449 1.661-0.871 3.472-1.851 5.504-2.625 31.064-18.395 67.171-25.491 102.36-27.538 0.306-17.431 2.448-35.68 10.949-51.65 7.08-13.269 19.369-23.599 34-27.179l0.061-0.03 0.079-9e-3c5.573-1.078 11.192-1.575 16.774-1.575 14.869 0 29.561 3.521 43.31 9.017 6.086-9.185 14.776-16.354 24.97-20.375l0.098-0.056 0.098-0.037c5.983-1.864 12.303-2.954 18.646-2.954 6.692 0 13.437 1.223 19.756 4.046v-0.023c9e-3 0.023 0.019 0.023 0.019 0.023 0.047 0.016 0.084 0.044 0.116 0.044 9.059 3.489 16.727 9.937 22.164 17.95 5.442 8.048 8.644 17.688 8.644 27.599 0 1.827-0.103 3.657-0.317 5.489l-0.019 0.037c0 0.028 0 0.068-0.01 0.096-1.063 12.809-7.551 24.047-16.736 32.063-9.24 8.048-21.207 12.909-33.49 12.909-1.97 0-3.958-0.11-5.937-0.374-12.182-0.931-23.541-6.826-31.886-15.595-8.373-8.755-13.768-20.453-13.768-33.08 0-0.611 0.056-1.237 0.074-1.843-11.435-5.092-23.578-9.316-35.646-9.306-1.746 0-3.491 0.096-5.237 0.273h-0.019c-9.035 0.871-17.436 6.566-21.506 14.757v0.037c-6.179 12.034-7.411 26.101-7.598 40.064 34.639 2.259 69.483 10.571 100.04 28.138h0.047l0.438 0.259c0.579 0.343 1.652 0.931 2.623 1.449 2.101-1.704 4.322-3.456 6.856-4.966 9.264-6.17 20.241-9.238 31.223-9.238 4.872 0 9.749 0.621 14.481 1.834h0.019l0.196 0.058c0.07 0.01 0.121 0.033 0.178 0.033v9e-3c11.183 2.845 21.3 9.267 28.917 17.927 7.612 8.674 12.731 19.648 13.73 31.561v0.025h-0.012zm-102.03-113.36c0 0.469 0.01 0.95 0.057 1.44v0.084c0.224 6.018 3.065 11.619 7.383 15.756 4.34 4.14 10.1 6.702 15.942 6.725h0.159c0.42 0.033 0.85 0.033 1.26 0.033 5.899 9e-3 11.752-2.532 16.148-6.655 4.405-4.144 7.309-9.78 7.542-15.849l9e-3 -0.028v-0.037c0.038-0.464 0.057-0.903 0.057-1.377 0-6.247-2.922-12.202-7.496-16.612-4.555-4.406-10.688-7.136-16.735-7.12-1.951 0-3.884 0.266-5.778 0.854l-0.065 5e-3 -0.056 0.023c-4.984 1.295-9.656 4.368-13.012 8.449-3.371 4.062-5.415 9.084-5.415 14.309zm-255.69 92.845c-4.63-2.156-9.418-3.696-14.15-3.676-0.794 0-1.597 0.047-2.39 0.133h-0.11l-0.11 0.014c-6.795 0.187-13.653 3.15-18.801 7.899-5.152 4.732-8.559 11.122-8.821 18.167v0.065l-0.012 0.058c-0.046 0.57-0.065 1.137-0.065 1.683 0 4.345 1.333 8.545 3.593 12.368 1.673 2.847 3.867 5.441 6.348 7.701 7.941-17.388 20.348-32.145 34.518-44.412zm301.75 85.057c0-15.5-5.592-31.069-14.646-43.604-18.053-25.119-46.055-41.502-75.187-50.636l-0.205-0.072c-5.592-1.715-11.238-3.234-16.933-4.534-17.025-3.876-34.48-5.806-51.917-5.806-23.414 0-46.827 3.465-69.245 10.379-29.125 9.243-57.221 25.51-75.233 50.71v0.019c-9.129 12.587-14.475 28.208-14.475 43.763 0 5.727 0.716 11.453 2.23 17.025l0.019 0.01c3.278 12.508 9.689 23.671 17.989 33.393 8.295 9.745 18.472 18.058 29.176 24.839 2.371 1.47 4.751 2.87 7.187 4.237 31.094 17.356 66.898 24.964 102.44 24.964 6.012 0 12.06-0.214 18.033-0.644 35.797-2.959 71.742-13.525 100.8-35.115l0.01-0.023c9.25-6.837 17.818-15.112 24.595-24.525 6.805-9.418 11.789-19.947 14.002-31.382v-0.033l9e-3 -0.01c0.907-4.27 1.346-8.605 1.346-12.955zm28.254-61.685c-9e-3 -3.762-0.868-7.507-2.753-11l-0.047-0.044-0.019-0.056c-2.521-5.19-6.479-9.11-11.248-11.782-4.77-2.69-10.352-4.056-15.952-4.056-5.063 0-10.1 1.132-14.57 3.379 14.216 12.344 26.687 27.179 34.746 44.636 2.595-2.259 4.808-5.018 6.464-8.084 2.157-4.023 3.379-8.538 3.379-12.993z"/>
								</svg>',
    ),
    15 => array(
        'id'      => 16,
        'class'      => 'dribbble',
        'share'     => '',
        'icon'        =>  '<svg width="438.53px" height="438.53px" enable-background="new 0 0 438.533 438.533" version="1.1" viewBox="0 0 438.533 438.533" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="m409.13 109.2c-19.608-33.592-46.205-60.189-79.798-79.796-33.599-19.606-70.277-29.407-110.06-29.407-39.781 0-76.47 9.801-110.06 29.407-33.595 19.604-60.192 46.201-79.8 79.796-19.609 33.597-29.41 70.286-29.41 110.06 0 39.78 9.804 76.463 29.407 110.06 19.607 33.592 46.204 60.189 79.799 79.798 33.597 19.605 70.283 29.407 110.06 29.407s76.47-9.802 110.06-29.407c33.593-19.602 60.189-46.206 79.795-79.798 19.603-33.596 29.403-70.284 29.403-110.06 1e-3 -39.782-9.8-76.472-29.399-110.06zm-189.86-77.226c47.201 0 88.41 15.607 123.62 46.82l-3.569 4.993c-1.427 2.002-4.996 5.852-10.704 11.565-5.709 5.708-11.943 11.136-18.699 16.274-6.762 5.14-15.94 10.992-27.555 17.559-11.611 6.567-23.982 12.328-37.117 17.276-21.887-40.355-45.296-76.709-70.231-109.06 15.039-3.616 29.789-5.423 44.254-5.423zm-146.75 71.083c18.271-23.026 40.537-40.73 66.806-53.1 23.601 31.405 46.82 67.381 69.662 107.92-57.862 15.227-115.53 22.841-173.01 22.838 6.094-28.739 18.275-54.628 36.546-77.659zm-27.984 183.73c-8.376-21.412-12.563-43.923-12.563-67.527 0-2.666 0.098-4.665 0.286-5.996 68.905 0 132.96-8.848 192.15-26.553 6.092 11.8 11.136 22.364 15.133 31.693-0.771 0.38-1.999 0.806-3.713 1.283-1.719 0.476-2.953 0.806-3.721 0.999l-10.561 3.711c-7.236 2.666-16.708 7.235-28.409 13.703-11.704 6.478-24.123 14.182-37.257 23.13-13.134 8.949-26.696 20.797-40.684 35.553-13.99 14.75-25.743 30.591-35.26 47.53-15.227-16.939-27.026-36.12-35.4-57.526zm174.73 119.77c-44.54 0-84.32-14.277-119.34-42.825l4.283 3.142c6.661-14.66 16.462-28.746 29.408-42.257 12.944-13.511 25.41-24.413 37.401-32.695 11.991-8.274 25.028-16.077 39.115-23.414 14.084-7.323 23.691-11.991 28.835-13.983 5.14-1.998 9.233-3.572 12.278-4.716l0.568-0.287h0.575c18.647 48.916 31.977 96.313 39.968 142.18-23.602 9.902-47.961 14.848-73.088 14.851zm157.61-86.081c-14.086 21.796-31.696 39.834-52.817 54.104-7.81-43.776-19.985-88.415-36.549-133.9 37.877-5.907 76.8-3.142 116.77 8.274-4.189 25.886-13.326 49.732-27.405 71.524zm26.83-103.78c-1.903-0.378-4.285-0.81-7.139-1.283s-6.331-1.047-10.424-1.713c-4.087-0.666-8.662-1.283-13.702-1.855-5.045-0.571-10.421-1.093-16.136-1.569-5.708-0.478-11.8-0.855-18.268-1.143-6.479-0.284-13.042-0.428-19.705-0.428-6.656 0-13.657 0.193-20.981 0.571-7.326 0.375-14.414 1.049-21.265 1.999-0.575-0.953-1.287-2.524-2.143-4.714-0.855-2.187-1.479-3.855-1.848-4.997-3.621-7.994-7.81-17.036-12.573-27.121 13.134-5.333 25.652-11.469 37.555-18.418 11.892-6.949 21.402-13.131 28.544-18.555 7.139-5.43 13.895-11.188 20.27-17.277 6.379-6.09 10.513-10.323 12.423-12.703 1.906-2.384 3.713-4.714 5.424-6.995l0.287-0.288c27.788 33.88 41.974 72.897 42.538 117.06l-2.857-0.57z"/>
								</svg>',
    ),
    16 => array(
        'id'      => 17,
        'class'      => 'twitch',
        'share'     => '',
        'icon'        =>  '<svg enable-background="new 0 0 512 512" version="1.1" viewBox="0 0 512 512" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="M48,0L16,96v352h128v64h64l64-64h96l128-136.32V0H48z M464,288l-89.6,96H260.928L192,434.144V384H80V32h384V288z"/>
									<rect x="240" y="128" width="32" height="128"/>
									<rect x="336" y="128" width="32" height="128"/>
								</svg>',
    ),
    17 => array(
        'id'      => 18,
        'class'      => 'email',
        'share'     => 'mailto:?subject={title}&body={url}',
        'icon'        =>  '<svg enable-background="new 0 0 483.3 483.3" version="1.1" viewBox="0 0 483.3 483.3" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
									<path d="m424.3 57.75h-365.2c-32.6 0-59.1 26.5-59.1 59.1v249.6c0 32.6 26.5 59.1 59.1 59.1h365.1c32.6 0 59.1-26.5 59.1-59.1v-249.5c0.1-32.6-26.4-59.2-59-59.2zm32.1 308.7c0 17.7-14.4 32.1-32.1 32.1h-365.2c-17.7 0-32.1-14.4-32.1-32.1v-249.5c0-17.7 14.4-32.1 32.1-32.1h365.1c17.7 0 32.1 14.4 32.1 32.1v249.5h0.1z"/>
									<path d="m304.8 238.55l118.2-106c5.5-5 6-13.5 1-19.1-5-5.5-13.5-6-19.1-1l-163 146.3-31.8-28.4c-0.1-0.1-0.2-0.2-0.2-0.3-0.7-0.7-1.4-1.3-2.2-1.9l-129.4-115.8c-5.6-5-14.1-4.5-19.1 1.1s-4.5 14.1 1.1 19.1l119.6 106.9-119.1 111.5c-5.4 5.1-5.7 13.6-0.6 19.1 2.7 2.8 6.3 4.3 9.9 4.3 3.3 0 6.6-1.2 9.2-3.6l120.9-113.1 32.8 29.3c2.6 2.3 5.8 3.4 9 3.4s6.5-1.2 9-3.5l33.7-30.2 120.2 114.2c2.6 2.5 6 3.7 9.3 3.7 3.6 0 7.1-1.4 9.8-4.2 5.1-5.4 4.9-14-0.5-19.1l-118.7-112.7z"/>
								</svg>',
    ),

    18 => array(
        'id'      => 19,
        'class'      => 'whatsapp',
        'share'     => 'https://api.whatsapp.com/send?text={title}%20{url}',
        'icon'        =>  '<svg height="682pt" viewBox="-23 -21 682 682.66669" width="682pt" xmlns="http://www.w3.org/2000/svg"><path d="m544.386719 93.007812c-59.875-59.945312-139.503907-92.9726558-224.335938-93.007812-174.804687 0-317.070312 142.261719-317.140625 317.113281-.023437 55.894531 14.578125 110.457031 42.332032 158.550781l-44.992188 164.335938 168.121094-44.101562c46.324218 25.269531 98.476562 38.585937 151.550781 38.601562h.132813c174.785156 0 317.066406-142.273438 317.132812-317.132812.035156-84.742188-32.921875-164.417969-92.800781-224.359376zm-224.335938 487.933594h-.109375c-47.296875-.019531-93.683594-12.730468-134.160156-36.742187l-9.621094-5.714844-99.765625 26.171875 26.628907-97.269531-6.269532-9.972657c-26.386718-41.96875-40.320312-90.476562-40.296875-140.28125.054688-145.332031 118.304688-263.570312 263.699219-263.570312 70.40625.023438 136.589844 27.476562 186.355469 77.300781s77.15625 116.050781 77.132812 186.484375c-.0625 145.34375-118.304687 263.59375-263.59375 263.59375zm144.585938-197.417968c-7.921875-3.96875-46.882813-23.132813-54.148438-25.78125-7.257812-2.644532-12.546875-3.960938-17.824219 3.96875-5.285156 7.929687-20.46875 25.78125-25.09375 31.066406-4.625 5.289062-9.242187 5.953125-17.167968 1.984375-7.925782-3.964844-33.457032-12.335938-63.726563-39.332031-23.554687-21.011719-39.457031-46.960938-44.082031-54.890626-4.617188-7.9375-.039062-11.8125 3.476562-16.171874 8.578126-10.652344 17.167969-21.820313 19.808594-27.105469 2.644532-5.289063 1.320313-9.917969-.664062-13.882813-1.976563-3.964844-17.824219-42.96875-24.425782-58.839844-6.4375-15.445312-12.964843-13.359374-17.832031-13.601562-4.617187-.230469-9.902343-.277344-15.1875-.277344-5.28125 0-13.867187 1.980469-21.132812 9.917969-7.261719 7.933594-27.730469 27.101563-27.730469 66.105469s28.394531 76.683594 32.355469 81.972656c3.960937 5.289062 55.878906 85.328125 135.367187 119.648438 18.90625 8.171874 33.664063 13.042968 45.175782 16.695312 18.984374 6.03125 36.253906 5.179688 49.910156 3.140625 15.226562-2.277344 46.878906-19.171875 53.488281-37.679687 6.601563-18.511719 6.601563-34.375 4.617187-37.683594-1.976562-3.304688-7.261718-5.285156-15.183593-9.253906zm0 0" fill-rule="evenodd"/></svg>',
    ),

    19 => array(
        'id'      => 20,
        'class'      => 'spotify',
        'share'     => '',
        'icon'        =>  '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                  viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
             <g>
                 <g>
                     <path d="M407,0H105C47.103,0,0,47.103,0,105v302c0,57.897,47.103,105,105,105h302c57.897,0,105-47.103,105-105V105
                         C512,47.103,464.897,0,407,0z M383,316v15v25c0,22.056-17.944,40-40,40h-25c-22.056,0-40-17.944-40-40c0-22.056,17.944-40,40-40
                         h35V168.807l-144,24.828V346v15v25c0,22.056-17.944,40-40,40h-25c-22.056,0-40-17.944-40-40c0-22.056,17.944-40,40-40h35V118.365
                         l204-35.172V316z"/>
                 </g>
             </g>
             </svg>',
    ),

    20 => array(
        'id'      => 21,
        'class'      => 'bandcamp',
        'share'     => '',
        'icon'        =>  '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                  width="97.236px" height="97.236px" viewBox="0 0 97.236 97.236" style="enable-background:new 0 0 97.236 97.236;"
                  xml:space="preserve">
             <g>
                 <polygon points="0,78.075 70.006,78.075 97.236,19.161 27.23,19.161 	"/>
             </g>
             </svg>',
    ),
    21 => array(
        'id'      => 22,
        'alt-name' => 'apple music',
        'alt-link' => 'apple',
        'class'      => 'applemusic',
        'share'     => '',
        'icon'        =>  '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                  viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
             <g>
                 <g>
                     <path d="M407,0H105C47.103,0,0,47.103,0,105v302c0,57.897,47.103,105,105,105h302c57.897,0,105-47.103,105-105V105
                         C512,47.103,464.897,0,407,0z M383,316v15v25c0,22.056-17.944,40-40,40h-25c-22.056,0-40-17.944-40-40c0-22.056,17.944-40,40-40
                         h35V168.807l-144,24.828V346v15v25c0,22.056-17.944,40-40,40h-25c-22.056,0-40-17.944-40-40c0-22.056,17.944-40,40-40h35V118.365
                         l204-35.172V316z"/>
                 </g>
             </g>
             </svg>',
    ),
    22 => array(
        'id'      => 23,
        'alt-name' => 'apple podcasts',
        'alt-link' => 'apple',
        'class'      => 'applepodcasts',
        'share'     => '',
        'icon'        =>  '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                  viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
             <g>
                 <g>
                     <path d="M407,0H105C47.103,0,0,47.103,0,105v302c0,57.897,47.103,105,105,105h302c57.897,0,105-47.103,105-105V105
                         C512,47.103,464.897,0,407,0z M308.558,340.537l-9.273,74.185C297.408,429.734,284.646,441,269.517,441h-27.033
                         c-15.13,0-27.892-11.266-29.768-26.279l-9.273-74.185C199.49,308.923,224.14,281,256,281c-24.813,0-45-20.187-45-45
                         s20.187-45,45-45s45,20.187,45,45s-20.187,45-45,45C287.86,281,312.51,308.923,308.558,340.537z M256,161
                         c-46.869,0-85,38.131-85,85c0,16.893,4.974,32.637,13.505,45.883c-6.132,10.42-9.908,22.057-11.076,34.072
                         C153.368,305.245,141,277.042,141,246c0-63.411,51.589-115,115-115s115,51.589,115,115c0,31.042-12.368,59.245-32.428,79.956
                         c-1.168-12.016-4.945-23.652-11.076-34.072C336.026,278.637,341,262.893,341,246C341,199.131,302.869,161,256,161z
                          M330.838,404.168l4.617-36.938C374.901,341.289,401,296.639,401,246c0-79.953-65.047-145-145-145s-145,65.047-145,145
                         c0,50.639,26.099,95.289,65.545,121.23l4.617,36.938C122.004,376.063,81,315.734,81,246c0-96.495,78.505-175,175-175
                         s175,78.505,175,175C431,315.734,389.996,376.063,330.838,404.168z"/>
                 </g>
             </g>
             </svg>',
    ),
    23 => array(
        'id'      => 24,
        'alt-name' => 'apple books',
        'alt-link' => 'apple',
        'class'      => 'applebooks',
        'share'     => '',
        'icon'        =>  '<svg xmlns="http://www.w3.org/2000/svg" width="512" height="512" viewBox="0 0 512 512"><path d="M407,512H105a105.892,105.892,0,0,1-21.151-2.153,104.546,104.546,0,0,1-37.527-15.815A105.424,105.424,0,0,1,8.283,447.85a104.6,104.6,0,0,1-6.13-19.7A105.894,105.894,0,0,1,0,407V105A105.892,105.892,0,0,1,2.153,83.85,104.547,104.547,0,0,1,17.968,46.323,105.425,105.425,0,0,1,64.15,8.283a104.594,104.594,0,0,1,19.7-6.13A105.892,105.892,0,0,1,105,0H407a105.894,105.894,0,0,1,21.151,2.153,104.548,104.548,0,0,1,37.527,15.815,105.426,105.426,0,0,1,38.04,46.182,104.594,104.594,0,0,1,6.13,19.7A105.892,105.892,0,0,1,512,105V407a105.893,105.893,0,0,1-2.153,21.151,104.547,104.547,0,0,1-15.815,37.527,105.425,105.425,0,0,1-46.182,38.04,104.6,104.6,0,0,1-19.7,6.13A105.893,105.893,0,0,1,407,512ZM103.595,97a15.483,15.483,0,0,0-10.97,4.559A15.644,15.644,0,0,0,88,112.706V348.195a15.758,15.758,0,0,0,15.724,15.7,263.453,263.453,0,0,1,31.363,1.931,226.552,226.552,0,0,1,36.526,7.481c29.175,8.629,53.453,22.931,72.159,42.506V169.368a15.032,15.032,0,0,0-2.159-7.953C206.935,105.569,140.3,97.087,103.662,97h-.067Zm304.671,0c-36.635.086-103.272,8.57-137.952,64.416a15.039,15.039,0,0,0-2.156,7.953V415.813c18.706-19.576,42.983-33.878,72.157-42.507a226.556,226.556,0,0,1,36.526-7.481,263.471,263.471,0,0,1,31.364-1.932,15.755,15.755,0,0,0,15.72-15.7V112.705a15.64,15.64,0,0,0-4.621-11.146A15.479,15.479,0,0,0,408.334,97h-.069Z"/></svg>',
    ),
    24 => array(
        'id'      => 25,
        'alt-name' => 'appstore',
        'alt-link' => 'apple',
        'class'      => 'appstore',
        'share'     => '',
        'icon'        =>  '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 333334 332780" shape-rendering="geometricPrecision" text-rendering="geometricPrecision" image-rendering="optimizeQuality" fill-rule="evenodd" clip-rule="evenodd"><path d="M67387 0h198559c37063 0 67387 30324 67387 67387v198005c0 37063-30324 67387-67387 67387H67387C30324 332779 0 302455 0 265392V67387C0 30324 30324 0 67387 0zm192804 188911c8471 0 15339 6868 15339 15339 0 8472-6868 15339-15339 15339h-13707l12369 21361c4186 7375 1601 16748-5774 20934-7376 4186-16748 1600-20933-5775l-21148-36520h-292l-18180-30679h707l-17948-30995 17460-31129 35974 62123h31472zM137016 91830c-4186-7376-1601-16748 5775-20934 7375-4186 16748-1601 20933 5774l3533 6102 3041-5232c4186-7375 13559-9960 20934-5774s9960 13559 5775 20933l-12043 20650 35 60-9218 15688-34881 59815h36634l17798 30678-71907 1-19809 34780c-4186 7375-13559 9960-20933 5774-7375-4186-9961-13558-5774-20934l11175-19619H73143c-8471 0-15339-6868-15339-15340 0-8471 6868-15339 15339-15339h32415l43922-75559-12464-21524z"/></svg>',
    ),
    25 => array(
        'id'      => 26,
        'alt-name' => 'google play',
        'alt-link' => 'google',
        'class'      => 'googleplay',
        'share'     => '',
        'icon'        =>  '<svg viewBox="0 0 40 40" xmlns="http://www.w3.org/2000/svg"><g data-name="Google Play"><path d="M10.09,8a1.94,1.94,0,0,1,1.28.28l13,7.39L21.08,19Zm-1,1A2.31,2.31,0,0,0,9,9.67V30.33a2.31,2.31,0,0,0,.09.67l11-11Zm12,12-11,11a1.88,1.88,0,0,0,1.28-.28l13-7.39Zm8.52-2.34-3.94-2.24L22.07,20l3.59,3.59,3.94-2.24C30.9,20.61,30.9,19.39,29.6,18.65Z"/></g></svg>',
    ),
    26 => array(
        'id'      => 27,
        'class'      => 'tiktok',
        'share'     => '',
        'icon'        =>  '<svg enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m480.32 128.39c-29.22 0-56.18-9.68-77.83-26.01-24.83-18.72-42.67-46.18-48.97-77.83-1.56-7.82-2.4-15.89-2.48-24.16h-83.47v228.08l-.1 124.93c0 33.4-21.75 61.72-51.9 71.68-8.75 2.89-18.2 4.26-28.04 3.72-12.56-.69-24.33-4.48-34.56-10.6-21.77-13.02-36.53-36.64-36.93-63.66-.63-42.23 33.51-76.66 75.71-76.66 8.33 0 16.33 1.36 23.82 3.83v-62.34-22.41c-7.9-1.17-15.94-1.78-24.07-1.78-46.19 0-89.39 19.2-120.27 53.79-23.34 26.14-37.34 59.49-39.5 94.46-2.83 45.94 13.98 89.61 46.58 121.83 4.79 4.73 9.82 9.12 15.08 13.17 27.95 21.51 62.12 33.17 98.11 33.17 8.13 0 16.17-.6 24.07-1.77 33.62-4.98 64.64-20.37 89.12-44.57 30.08-29.73 46.7-69.2 46.88-111.21l-.43-186.56c14.35 11.07 30.04 20.23 46.88 27.34 26.19 11.05 53.96 16.65 82.54 16.64v-60.61-22.49c.02.02-.22.02-.24.02z"/></g></svg>',
    ),
    27 => array(
        'id'      => 28,
        'class'      => 'telegram',
        'share'        => 'https://t.me/share/url?url={url}&text={title}',
        'icon'        =>  '<svg xmlns="http://www.w3.org/2000/svg" width="92.915" height="77.924" viewBox="0 0 92.915 77.924"><g transform="translate(0 0)"><path d="M118.652,70.205,104.63,136.331c-1.058,4.667-3.817,5.828-7.737,3.63L75.529,124.218,65.22,134.133c-1.14,1.141-2.095,2.1-4.294,2.1l1.535-21.759,39.6-35.78c1.722-1.535-.373-2.385-2.676-.85L50.431,108.661l-21.074-6.6c-4.584-1.431-4.667-4.584.954-6.783L112.74,63.527C116.556,62.1,119.9,64.377,118.652,70.205Z" transform="translate(-26.001 -63.112)" fill="#fff"/></g></svg>',
    ),
    28 => array(
        'id'      => 29,
        'class'     => 'mastodon',
        'share'     => 'https://mastodon.social/share?text={title}%20{url}',
        'icon'      =>  '<svg width="24px" height="24px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" xml:space="preserve"><path d="M21.327 8.566c0-4.339-2.843-5.61-2.843-5.61-1.433-.658-3.894-.935-6.451-.956h-.063c-2.557.021-5.016.298-6.45.956 0 0-2.843 1.272-2.843 5.61 0 .993-.019 2.181.012 3.441.103 4.243.778 8.425 4.701 9.463 1.809.479 3.362.579 4.612.51 2.268-.126 3.541-.809 3.541-.809l-.075-1.646s-1.621.511-3.441.449c-1.804-.062-3.707-.194-3.999-2.409a4.523 4.523 0 0 1-.04-.621s1.77.433 4.014.536c1.372.063 2.658-.08 3.965-.236 2.506-.299 4.688-1.843 4.962-3.254.434-2.223.398-5.424.398-5.424zm-3.353 5.59h-2.081V9.057c0-1.075-.452-1.62-1.357-1.62-1 0-1.501.647-1.501 1.927v2.791h-2.069V9.364c0-1.28-.501-1.927-1.502-1.927-.905 0-1.357.546-1.357 1.62v5.099H6.026V8.903c0-1.074.273-1.927.823-2.558.566-.631 1.307-.955 2.228-.955 1.065 0 1.872.409 2.405 1.228l.518.869.519-.869c.533-.819 1.34-1.228 2.405-1.228.92 0 1.662.324 2.228.955.549.631.822 1.484.822 2.558v5.253z"/></svg>'
    ),
    29 => array(
        'id'        => 30,
        'class'     => 'goodreads',
        'share'     => '',
        'icon'      =>  '<svg width="24px" height="24px" viewBox="0 0 24 24" role="img" xmlns="http://www.w3.org/2000/svg"><path d="M19.525 15.977V.49h-2.059v2.906h-.064c-.211-.455-.481-.891-.842-1.307-.36-.412-.767-.777-1.232-1.094-.466-.314-.962-.561-1.519-.736C13.256.09 12.669 0 12.038 0c-1.21 0-2.3.225-3.246.67-.947.447-1.743 1.057-2.385 1.83-.642.773-1.133 1.676-1.47 2.711-.336 1.037-.506 2.129-.506 3.283 0 1.199.141 2.326.425 3.382.286 1.057.737 1.976 1.368 2.762.631.78 1.412 1.397 2.375 1.833.961.436 2.119.661 3.471.661 1.248 0 2.33-.315 3.262-.946s1.638-1.473 2.119-2.525h.061v2.284c0 2.044-.421 3.607-1.264 4.705-.84 1.081-2.224 1.638-4.146 1.638-.572 0-1.128-.061-1.669-.181-.542-.12-1.036-.315-1.487-.57-.437-.271-.827-.601-1.143-1.038-.316-.435-.526-.961-.632-1.593H5.064c.067.887.315 1.654.737 2.3.424.646.961 1.172 1.602 1.593.641.406 1.367.706 2.172.902.811.194 1.639.3 2.494.3 1.383 0 2.541-.195 3.486-.555.947-.376 1.714-.902 2.301-1.608.601-.708 1.021-1.549 1.293-2.556.27-1.007.42-2.134.42-3.367l-.044.062zm-7.484-.557c-.955 0-1.784-.189-2.479-.571-.697-.38-1.277-.882-1.732-1.503-.467-.621-.797-1.332-1.022-2.139s-.332-1.633-.332-2.484c0-.871.105-1.725.301-2.563.21-.84.54-1.587.992-2.24.451-.652 1.037-1.182 1.728-1.584s1.533-.605 2.51-.605 1.803.209 2.495.621c.676.415 1.247.959 1.683 1.634.436.677.751 1.429.947 2.255.195.826.285 1.656.285 2.482 0 .852-.12 1.678-.345 2.484-.226.807-.572 1.518-1.038 2.139-.465.621-1.021 1.123-1.698 1.503-.676.382-1.458.571-2.359.571h.064z"/></svg>'
    ),
    30 => array(
        'id'        => 31,
        'class'     => 'threads',
        'share'     => '',
        'icon'      => '<svg aria-label="Threads" viewBox="0 0 192 192" xmlns="http://www.w3.org/2000/svg"><path class="x19hqcy" d="M141.537 88.9883C140.71 88.5919 139.87 88.2104 139.019 87.8451C137.537 60.5382 122.616 44.905 97.5619 44.745C97.4484 44.7443 97.3355 44.7443 97.222 44.7443C82.2364 44.7443 69.7731 51.1409 62.102 62.7807L75.881 72.2328C81.6116 63.5383 90.6052 61.6848 97.2286 61.6848C97.3051 61.6848 97.3819 61.6848 97.4576 61.6855C105.707 61.7381 111.932 64.1366 115.961 68.814C118.893 72.2193 120.854 76.925 121.825 82.8638C114.511 81.6207 106.601 81.2385 98.145 81.7233C74.3247 83.0954 59.0111 96.9879 60.0396 116.292C60.5615 126.084 65.4397 134.508 73.775 140.011C80.8224 144.663 89.899 146.938 99.3323 146.423C111.79 145.74 121.563 140.987 128.381 132.296C133.559 125.696 136.834 117.143 138.28 106.366C144.217 109.949 148.617 114.664 151.047 120.332C155.179 129.967 155.42 145.8 142.501 158.708C131.182 170.016 117.576 174.908 97.0135 175.059C74.2042 174.89 56.9538 167.575 45.7381 153.317C35.2355 139.966 29.8077 120.682 29.6052 96C29.8077 71.3178 35.2355 52.0336 45.7381 38.6827C56.9538 24.4249 74.2039 17.11 97.0132 16.9405C119.988 17.1113 137.539 24.4614 149.184 38.788C154.894 45.8136 159.199 54.6488 162.037 64.9503L178.184 60.6422C174.744 47.9622 169.331 37.0357 161.965 27.974C147.036 9.60668 125.202 0.195148 97.0695 0H96.9569C68.8816 0.19447 47.2921 9.6418 32.7883 28.0793C19.8819 44.4864 13.2244 67.3157 13.0007 95.9325L13 96L13.0007 96.0675C13.2244 124.684 19.8819 147.514 32.7883 163.921C47.2921 182.358 68.8816 191.806 96.9569 192H97.0695C122.03 191.827 139.624 185.292 154.118 170.811C173.081 151.866 172.51 128.119 166.26 113.541C161.776 103.087 153.227 94.5962 141.537 88.9883ZM98.4405 129.507C88.0005 130.095 77.1544 125.409 76.6196 115.372C76.2232 107.93 81.9158 99.626 99.0812 98.6368C101.047 98.5234 102.976 98.468 104.871 98.468C111.106 98.468 116.939 99.0737 122.242 100.233C120.264 124.935 108.662 128.946 98.4405 129.507Z"></path></svg>'
    )
);
